<?php
/***************************************************************************
*                                                                          *
*   (c) 2004 Vladimir V. Kalynyak, Alexey V. Vinokurov, Ilya M. Shalnev    *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

if (!defined('BOOTSTRAP')) { die('Access denied'); }

$card_type = fn_get_payment_card($order_info['payment_info']['card_number'], array(
    'visa_debit' => 'VISA DEBIT',
    'visa' => 'VISA',
    'mastercard_debit' => 'DEBIT MASTERCARD',
    'mastercard' => 'MASTERCARD',
    'amex' => 'AMEX',
    'jcb' => 'JCB',
    'maestro' => 'MAESTRO',
    'diners_club_carte_blanche' => 'DINERS',
    'diners_club_international' => 'DINERS',
    'discover' => 'DISCOVER'
));

$_order_id = ($order_info['repaid']) ? ($order_id .'_'. $order_info['repaid']) : $order_id;
$_order_id = substr($_order_id,0,12);
$expiry_date = str_pad($order_info['payment_info']['expiry_month'],2,'0',STR_PAD_LEFT) . str_pad($order_info['payment_info']['expiry_year'],2,'0',STR_PAD_LEFT);

$gateway = $processor_data['processor_params']['gateway'];
$test = ($processor_data['processor_params']['test'] == '1' ? true : false);
$avs = ($processor_data['processor_params']['avs'] == '1' ? true : false);
$email = ($processor_data['processor_params']['send_email'] == '1' ? true : false);
$cvv = $order_info['payment_info']['cvv2'];

require_once 'worldnettps_files/worldnet_tps_xml.php';

#$currency = $_SESSION['settings']['secondary_currencyC']['value'];
$currency = $order_info['secondary_currency'];

switch ($currency) {
    case $processor_data['processor_params']['currency_one'] :
        $terminalID = $processor_data['processor_params']['terminal_id_one'];
        $sharedSecret = $processor_data['processor_params']['shared_secret_one'];
	break;
    case $processor_data['processor_params']['currency_two'] :
        $terminalID = $processor_data['processor_params']['terminal_id_two'];
        $sharedSecret = $processor_data['processor_params']['shared_secret_two'];
	break;
    case $processor_data['processor_params']['currency_three'] :
        $terminalID = $processor_data['processor_params']['terminal_id_three'];
        $sharedSecret = $processor_data['processor_params']['shared_secret_three'];
	break;
    default:
	die("Cart Currency not configured for WorldNet Payment plug-in. Transaction not processed.");
}

$sale = new XmlAuthRequest($terminalID, $_order_id, $currency, $order_info['total'], $order_info['payment_info']['card_number'], $card_type);
$sale->SetNonSecureCardCardInfo($expiry_date, $order_info['payment_info']['cardholder_name']);

if ($cvv != '') {
    $sale->SetCvv($cvv);
}

if ($avs) {
    $address1 = $order_info['b_address'];
    $address2 = $order_info['b_city'] . ", " . $order_info['b_state'];
    $postcode = $order_info['b_zipcode'];

    $sale->SetAvs($address1,$address2,$postcode);
}

if ($email) {
    $sale->SetEmail($order_info['email']);
}

// Perform Auth
$response = $sale->ProcessRequest($sharedSecret,$test,$gateway);

// Verify response hash
$hash = md5($terminalID . $response->UniqueRef() . $order_info['total'] . $response->DateTime() . $response->ResponseCode() . $response->ResponseText() . $sharedSecret);

if ($response->IsError()) {
        $pp_response['order_status'] = "F";
        $pp_response["reason_text"] = $response->ErrorString();
} elseif ($response->Hash() != $hash) {
        $pp_response['order_status'] = "F";
        $pp_response["reason_text"] = __('worldnettps_hash_error') . " (".$hash." vs ".$response->Hash().")";
} else {
        $pp_response['order_status'] = ($response->ResponseCode() == "A" ? "P" : "F");
        $pp_response["reason_text"] = "Bank response: ".$response->ResponseText();
        $pp_response["transaction_id"] = $response->UniqueRef();
}
