<?php
/*
+--------------------------------------------------------------------------
|   CubeCart v3
|   ========================================
|   by Alistair Brookbanks
|	CubeCart is a Trade Mark of Devellion Limited
|   Copyright Devellion Limited 2005 - 2006. All rights reserved.
|   Devellion Limited,
|   5 Bridge Street,
|   Bishops Stortford,
|   HERTFORDSHIRE.
|   CM23 2JU
|   UNITED KINGDOM
|   http://www.devellion.com
|	UK Private Limited Company No. 5323904
|   ========================================
|   Web: http://www.cubecart.com
|   Date: Friday, 15 July 2005
|   Email: sales (at) cubecart (dot) com
|	License Type: CubeCart is NOT Open Source Software and Limitations Apply 
|   Licence Info: http://www.cubecart.com/site/faq/license.php
+--------------------------------------------------------------------------
|	transfer.php
|   ========================================
|	Core functions for the Authorize.Net Gateway	
+--------------------------------------------------------------------------
*/

$module = fetchDbConfig("WorldNet_HPP");

function repeatVars(){
		return FALSE;
}

function fixedVars(){
	global $module, $basket, $ccUserData, $cart_order_id, $config, $GLOBALS; 

	$terminalid = $module['terminalid'];
	$secret = $module['sharedsecret'];
	$orderId = substr($cart_order_id,0,12);
	$currency = $config['defaultCurrency'];
	$email = $ccUserData[0]['email'];
	$description = $cart_order_id;
	$amount = $basket['grandTotal'];
	// Trim currency indicator sign if it exists
	if (substr($amount, 0,1) == "$" || substr($amount, 0,1) == "" || substr($amount, 0,1) == "" || substr($amount, 0,1) == "") {
		$amount = substr($amount,1);
	}
	
	function generateUniqueOrderId() {
		$seconds = date('H')*3600+date('i')*60+date('s');
		return date('zy') . $seconds;
	}
	$orderId = generateUniqueOrderId();

	function requestDateTime() {
		return date('d-m-Y:H:i:s:000');
	}
	$dateTime = requestDateTime();

	function authRequestHash($terminalid, $orderId, $amount, $dateTime, $secret) {
		return md5($terminalid . $orderId . $amount . $dateTime . $secret);
	}

	$hiddenVars =  "<input type='hidden' name='TERMINALID' value='" . $terminalid . "' />
					<input type='hidden' name='CURRENCY' value='" . $currency . "' />
					<input type='hidden' name='AMOUNT' value='" . $amount . "' />
					<input type='hidden' name='ORDERID' value='" . $orderId . "' />
					<input type='hidden' name='CubeCart order ID' value='" . $description . "' />
					<input type='hidden' name='DATETIME' value='" . $dateTime . "' />
					<input type='hidden' name='HASH' value='" . authRequestHash($terminalid, $orderId, $amount, $dateTime, $secret) . "' />";
	if ($module['sendmail'] == "Y") $hiddenVars .= "<input type='hidden' name='EMAIL' value='" . $email . "' />";
			
	return $hiddenVars;
}

function successFirst() {
	if($_REQUEST['RESPONSECODE'] == "A" && isset($_REQUEST['ORDERID'])) return TRUE;
	else return FALSE;
}

function success() {
	if($_GET['f']==1) return FALSE;
	else return TRUE;
}

///////////////////////////
// Other Vars
///////////////////////////
if($module['testMode'] == "Y") $formAction = "https://testpayments.worldnettps.com/merchant/paymentpage";
else $formAction = "https://payments.worldnettps.com/merchant/paymentpage";

$formMethod = "post";
$formTarget = "_self";
$transfer = "auto";
$stateUpdate = TRUE;

?>
