<?php

	class CHECKOUT_WORLDNETXML extends ISC_GENERIC_CREDITCARD
	{
		protected $amount;

		/*
			Checkout class constructor
		*/
		public function __construct()
		{
			// Setup the required variables for the WorldNet XML checkout module
			$this->_languagePrefix = "WorldNetXML";
			$this->_id = "checkout_worldnet";
			$this->_image = "worldnethpp_logo.jpg";

			parent::__construct();

			$this->_name = GetLang($this->_languagePrefix."Name");
			$this->_description = GetLang($this->_languagePrefix."Desc");
			$this->_help = sprintf(GetLang($this->_languagePrefix."Help"), $GLOBALS['ShopPathSSL']);

			$this->requiresSSL = true;
			$this->_currenciesSupported = array('GBP','EUR','USD');
			$this->_cardsSupported = array ('VISA','AMEX','MC','DINERS','SOLO','MAESTRO','SWITCH','LASER');

			$this->_liveTransactionURL = 'https://payments.worldnettps.com';
			$this->_testTransactionURL = 'https://testpayments.worldnettps.com';
			$this->_liveTransactionURI = '/merchant/xmlpayment';
			$this->_testTransactionURI = '/merchant/xmlpayment';
			$this->_curlSupported = true;
			$this->_fsocksSupported = true;
		}

		/**
		* Custom variables for the checkout module. Custom variables are stored in the following format:
		* array(variable_id, variable_name, variable_type, help_text, default_value, required, [variable_options], [multi_select], [multi_select_height])
		* variable_type types are: text,number,password,radio,dropdown
		* variable_options is used when the variable type is radio or dropdown and is a name/value array.
		*/
		public function SetCustomVars()
		{
			$this->_variables['displayname'] = array("name" => GetLang($this->_languagePrefix."DisplayName"),
			   "type" => "textbox",
			   "help" => GetLang($this->_languagePrefix."DisplayNameHelp"),
			   "default" => GetLang($this->_languagePrefix."DisplayNameDefault"),
			   "required" => true
			);

			$this->_variables['testmode'] = array("name" => GetLang($this->_languagePrefix."TestMode"),
			   "type" => "dropdown",
			   "help" => GetLang($this->_languagePrefix."TestModeHelp"),
			   "default" => "YES",
			   "required" => true,
			   "options" => array(GetLang($this->_languagePrefix."TestModeNo") => "NO",
							  GetLang($this->_languagePrefix."TestModeYes") => "YES"
				),
				"multiselect" => false
			);

			$this->_variables['terminalid'] = array("name" => GetLang($this->_languagePrefix."TerminalId"),
			   "type" => "textbox",
			   "help" => GetLang($this->_languagePrefix."TerminalIdHelp"),
			   "default" => "",
			   "required" => true
			);

			$this->_variables['sharedsecret'] = array("name" => GetLang($this->_languagePrefix."SharedSecret"),
			   "type" => "password",
			   "help" => GetLang($this->_languagePrefix."SharedSecretHelp"),
			   "default" => "",
			   "required" => true
			);

			$this->_variables['sendhostemail'] = array("name" => GetLang($this->_languagePrefix.'SendHostEmail'),
			   "type" => "dropdown",
			   "help" => GetLang($this->_languagePrefix.'SendHostEmailHelp'),
			   "default" => "NO",
			   "required" => true,
			   "options" => array(GetLang($this->_languagePrefix.'SendHostEmailNo') => "NO",
							  GetLang($this->_languagePrefix.'SendHostEmailYes') => "YES"
				),
				"multiselect" => false
			);
			
			$this->_variables['cardcode'] = array("name" => GetLang($this->_languagePrefix.'CardCode'),
			   "type" => "dropdown",
			   "help" => GetLang($this->_languagePrefix.'CardCodeHelp'),
			   "default" => "YES",
			   "required" => true,
			   "options" => array(GetLang($this->_languagePrefix.'CardCodeNo') => "NO",
							  GetLang($this->_languagePrefix.'CardCodeYes') => "YES"
				),
				"multiselect" => false
			);

		}

		protected function _ConstructPostData($postData)
		{
			require_once(dirname(__FILE__) . '/lib/worldnet_tps_xml.php');

			$billingDetails = $this->GetBillingDetails();

			$this->amount = number_format($this->GetGatewayAmount(), 2, '.', '');
			$currency = GetDefaultCurrency();
			$currency = $currency['currencycode'];

			switch ($postData['cctype']) {
				case 'MC':		$cctype = 'MASTERCARD';
								break;
				default:		$cctype = $postData['cctype'];
								break;
			}
			
			$sale = new XmlAuthRequest($this->GetValue('terminalid'), $this->GetCombinedOrderId(), $currency, $this->amount, $postData['ccno'], $cctype);
			$sale->SetNonSecureCardCardInfo($postData['ccexpm'].$postData['ccexpy'], $postData['name']);
			if ($this->GetValue("cardcode") == "YES" && isset($postData['cccvd']) && $postData['cccvd'] != "") $sale->SetCvv($postData['cccvd']);
			if ($this->GetValue("sendhostemail") == "YES") $sale->SetEmail($billingDetails['ordbillemail']);
			if(isset($postData['ccissueno']) && $postData['ccissueno']!="") $sale->SetIssueNo($postData['ccissueno']);
			$sale->SetHash($this->GetValue('sharedsecret'));

			return $sale->GenerateXml();
		}

		protected function _HandleResponse($result)
		{
			require_once(dirname(__FILE__) . '/lib/worldnet_tps_xml.php');

			$response = new XmlAuthResponse($result);

			if($response->IsError()) {
				// Something went wrong, show the error message with the credit card form
				$this->SetError(GetLang($this->_languagePrefix.'SomethingWentWrong') . $response->ErrorString());
				return false;
			} else {
				$responseHashExpected = md5($this->GetValue('terminalid') . $this->GetCombinedOrderId() . $this->amount . $response->DateTime() . $response->ResponseCode() . $response->ResponseText() . $this->GetValue('sharedsecret'));
				if($response->Hash() != $responseHashExpected) {
					// Response Hash is incorrect, possible fraud.
					$this->SetError(GetLang($this->_languagePrefix.'ResponseHashWasWrong'));
					return false;
				} elseif($response->ResponseCode() == 'A') {
					// The order is valid, hook back into the checkout system's validation process
					$GLOBALS['ISC_CLASS_LOG']->LogSystemSuccess(array('payment', $this->GetName()), GetLang($this->_languagePrefix.'Success'));

					$updatedOrder = array(
						'ordpayproviderid' => $this->GetCombinedOrderId(),
						'ordpaymentstatus' => 'captured',
					);

					$this->UpdateOrders($updatedOrder);

					return true;
				} else {
					// Something went wrong, show the error message with the credit card form
					$GLOBALS['ISC_CLASS_LOG']->LogSystemError(array('payment', $this->GetName()), sprintf(GetLang($this->_languagePrefix.'Declined'), $response->ResponseCode(), $response->ResponseText()));
					$this->SetError(sprintf(GetLang($this->_languagePrefix.'Declined'), $response->ResponseText()));
					return false;
				}
			}
		}
	}
