<?php
/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace WorldnetPayments\Payment\Controller\Directpost;

use Magento\Payment\Block\Transparent\Iframe;

/**
 * DirectPost Payment Controller
 *
 * @author     Magento Core Team <core@magentocommerce.com>
 */
abstract class Payment extends \Magento\Framework\App\Action\Action
{
    /**
     * Core registry
     *
     * @var \Magento\Framework\Registry
     */
    protected $_coreRegistry = null;

    /**
     * @var \WorldnetPayments\Payment\Helper\DataFactory
     */
    protected $dataFactory;

    /**
     * Constructor
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Framework\Registry $coreRegistry
     * @param \WorldnetPayments\Payment\Helper\DataFactory $dataFactory
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \WorldnetPayments\Payment\Helper\DataFactory $dataFactory
    ) {
        $this->_coreRegistry = $coreRegistry;
        $this->dataFactory = $dataFactory;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Checkout\Model\Session
     */
    protected function _getCheckout()
    {
        return $this->_objectManager->get('Magento\Checkout\Model\Session');
    }

    /**
     * Get session model
     *
     * @return \WorldnetPayments\Payment\Model\Directpost\Session
     */
    protected function _getDirectPostSession()
    {
        return $this->_objectManager->get('WorldnetPayments\Payment\Model\Directpost\Session');
    }

    /**
     * Response action.
     * Action for WorldnetPayments TPS SIM Relay Request.
     *
     * @param string $area
     * @return void
     */
    protected function _responseAction($area = 'frontend')
    {
        $helper = $this->dataFactory->create($area);

        $params = [];
        //$data = $this->getRequest()->getPostValue();
        $data['x_invoice_num'] = $_GET['x_invoice_num'];
        $data['x_response_code'] = $_GET['x_response_code'];
        $data['x_response_reason_code'] = $_GET['x_response_reason_code'];
        $data['x_trans_id'] = $_GET['x_trans_id'];
        /* @var $paymentMethod \WorldnetPayments\Payment\Model\DirectPost */
        $paymentMethod = $this->_objectManager->create('WorldnetPayments\Payment\Model\Directpost');

        $result = [];
        if (!empty($data['x_invoice_num']) && $data['x_response_code'] && !empty($data['x_trans_id'])) {
            $result['x_invoice_num'] = $data['x_invoice_num'];
            $params['order_success'] = $helper->getSuccessOrderUrl($result);
        } else
            if (!empty($data['x_invoice_num']) && $data['x_response_code']==0) {
                $result['x_invoice_num'] = $data['x_invoice_num'];
                $params['order_success'] = $helper->getFailureOrderUrl($result);
            }

        try {
            if (!empty($data['store_id'])) {
                $paymentMethod->setStore($data['store_id']);
            }
            $paymentMethod->process($data);
            $result['success'] = $data['x_response_code'];
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            $this->_objectManager->get('Psr\Log\LoggerInterface')->critical($e);
            $result['success'] = 0;
            $result['error_msg'] = $e->getMessage();
        } catch (\Exception $e) {
            $this->_objectManager->get('Psr\Log\LoggerInterface')->critical($e);
            $result['success'] = 0;
            $result['error_msg'] = __('We can\'t process your order right now. Please try again later.');
        }

        if (!empty($data['controller_action_name'])
            && strpos($data['controller_action_name'], 'sales_order_') === false
        ) {
            if (!empty($data['key'])) {
                $result['key'] = $data['key'];
            }
            $result['controller_action_name'] = $data['controller_action_name'];
            $result['is_secure'] = isset($data['is_secure']) ? $data['is_secure'] : false;
            $params['redirect'] = $helper->getRedirectIframeUrl($result);
        }

        $this->_coreRegistry->register(Iframe::REGISTRY_KEY, $params);
        $this->_view->addPageLayoutHandles();
        $this->_view->loadLayout(false)->renderLayout();
    }

    /**
     * Return customer quote
     *
     * @param bool $cancelOrder
     * @param string $errorMsg
     * @return void
     */
    protected function _returnCustomerQuote($cancelOrder = false, $errorMsg = '')
    {
        $incrementId = $this->_getDirectPostSession()->getLastOrderIncrementId();
        if ($incrementId && $this->_getDirectPostSession()->isCheckoutOrderIncrementIdExist($incrementId)) {
            /* @var $order \Magento\Sales\Model\Order */
            $order = $this->_objectManager->create('Magento\Sales\Model\Order')->loadByIncrementId($incrementId);
            if ($order->getId()) {
                try {
                    /** @var \Magento\Quote\Api\CartRepositoryInterface $quoteRepository */
                    $quoteRepository = $this->_objectManager->create('Magento\Quote\Api\CartRepositoryInterface');
                    /** @var \Magento\Quote\Model\Quote $quote */
                    $quote = $quoteRepository->get($order->getQuoteId());

                    $quote->setIsActive(1)->setReservedOrderId(null);
                    $quoteRepository->save($quote);
                    $this->_getCheckout()->replaceQuote($quote);
                } catch (\Magento\Framework\Exception\NoSuchEntityException $e) {
                }
                $this->_getDirectPostSession()->removeCheckoutOrderIncrementId($incrementId);
                $this->_getDirectPostSession()->unsetData('quote_id');
                if ($cancelOrder) {
                    $order->registerCancellation($errorMsg)->save();
                }
            }
        }
    }
}
