<?php
/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace WorldnetPayments\Payment\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order;

class UpdateAllEditIncrementsObserver implements ObserverInterface
{
    /**
     *
     * @var \WorldnetPayments\Payment\Helper\Data
     */
    protected $worldnetpaymentsData;

    /**
     * @param \WorldnetPayments\Payment\Helper\Data $worldnetpaymentsData
     */
    public function __construct(
        \WorldnetPayments\Payment\Helper\Data $worldnetpaymentsData
    ) {
        $this->worldnetpaymentsData = $worldnetpaymentsData;
    }

    /**
     * Save order into registry to use it in the overloaded controller.
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        /* @var $order Order */
        $order = $observer->getEvent()->getData('order');
        $this->worldnetpaymentsData->updateOrderEditIncrements($order);

        return $this;
    }
}
